/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasFault;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWFaultDefinition
extends VWMLABase
implements Serializable {
    private static final long serialVersionUID = 7448L;
    private String m_Name = null;
    private String m_FaultMapName = null;
    private String m_FaultMessage = null;
    private IVWHasFault myInstruction = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-19 01:22:30 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/7 $";
    }

    public String getName() {
        return this.translateStr(this.m_Name);
    }

    public String getFaultMapName() {
        return this.translateStr(this.m_FaultMapName);
    }

    public String getFaultMessage() {
        return this.translateStr(this.m_FaultMessage);
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWFaultDefinitionInvalidName", "theName is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_Name)) {
            return;
        }
        try {
            if (this.myInstruction instanceof VWInvokeInstruction) {
                this.myInstruction.getFault(theName);
                throw new VWException("vw.api.VWFaultDefinitionNameAlreadyExists", "theName is invalid, (a fault named {0} already exists in this workflow definition).", theName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Name = theName;
    }

    public void setFaultMapName(String theFaultMapName) {
        this.m_FaultMapName = theFaultMapName;
    }

    public void setFaultMessage(String theFaultMessage) {
        this.m_FaultMessage = theFaultMessage;
    }

    protected VWFaultDefinition(IVWHasFault containingInst, String theName, String theFaultMessage, String theFaultMapName) throws VWException {
        if (containingInst == null) {
            throw new VWException("vw.api.VWFaultDefinitionInvalidWorkflow", "containingInst is invalid, (null).");
        }
        this.myInstruction = containingInst;
        this.setName(theName);
        this.setFaultMessage(theFaultMessage);
        this.setFaultMapName(theFaultMapName);
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep, int instId, int faultId) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep, instId, faultId);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep, int instId, int faultId) throws VWException {
        VWWorkflowSignature myWflSignature = myStep.getMap().getWorkflow().getWorkflowSignature(validationContext);
        VWWorkflowSignature myBaseWflSignature = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
        if (this.m_FaultMessage != null && this.m_FaultMessage.compareTo("") != 0) {
            VWCompiledRefExpr compRes = new VWCompiledRefExpr();
            String[] theErrorStrings = VWExpr.compileVWExpr(this.m_FaultMessage, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int i = 0; i < errorCount; ++i) {
                    String theMessage = "vw.api.VWFaultDefinitionSyntaxError" + theErrorStrings[i];
                    VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.m_FaultMessage, theMessage, myStep.getMap().getName(), myStep.getStepId(), instId);
                    validationContext.addValidationError(theError);
                }
            } else if (compRes.getResultIsArray() || compRes.getResultType() != 2 && compRes.getResultType() != 128) {
                VWString theMessage = new VWString("vw.api.VWFaultDefinitionMessageNotString", "Fault message expression must be a string, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()), compRes.getResultIsArray() ? "[ ]" : "");
                VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.m_FaultMessage, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                validationContext.addValidationError(theError);
            }
        }
        if (this.m_FaultMapName != null) {
            if (VWMapDefinition.mapNameToId(this.m_FaultMapName) == 0) {
                try {
                    myStep.getMap().getWorkflow().getMap(this.m_FaultMapName);
                }
                catch (Exception e) {
                    if (myBaseWflSignature == null || !myBaseWflSignature.isInstructionSheetName(this.m_FaultMapName)) {
                        VWString theMessage = new VWString("vw.api.VWFaultDefinitionMapNotFound", "{0}, The map to be called by the fault, {1}, was not found in this or the parent workflow definition.", this.m_Name, this.m_FaultMapName);
                        VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.m_FaultMapName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
                        validationContext.addValidationError(theError);
                    }
                }
            }
        } else {
            VWString theMessage = new VWString("vw.api.VWFaultDefinitionMapIsNull", "{0}, The map to be called by the fault is set to none, it must be a valid map name.", this.m_Name);
            VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.m_FaultMapName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), instId);
            validationContext.addValidationError(theError);
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWFaultDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t\t<catch");
        if (this.m_Name != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "faultName=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\"");
        }
        if (this.m_FaultMessage != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "faultVariable=\"" + VWXMLHandler.toXMLString(this.m_FaultMessage) + "\"");
        }
        if (this.m_FaultMapName != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "faultMap=\"" + VWXMLHandler.toXMLString(this.m_FaultMapName) + "\"");
        }
        theBuffer.append("/>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer, boolean isCatchAll, VWCompoundStepDefinition myCompoundStep) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWFaultDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<WebServiceFaultCatch");
        if (this.m_Name != null) {
            theBuffer.append(" FaultName=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\"");
        }
        if (isCatchAll) {
            theBuffer.append(" fn:CatchAll=\"true\"");
        }
        theBuffer.append(">\n");
        if (this.m_FaultMessage != null) {
            theBuffer.append(indentB + "<Message Id=\"FaultMessage\">\n");
            theBuffer.append(indentC + "<ActualParameters>\n");
            theBuffer.append(indentD + "<ActualParameter>" + VWXMLHandler.toXMLString(this.m_FaultMessage) + "</ActualParameter>\n");
            theBuffer.append(indentC + "</ActualParameters>\n");
            theBuffer.append(indentB + "</Message>\n");
        }
        if (this.m_FaultMapName != null) {
            VWWorkflowDefinition wfdef = myCompoundStep.getMap().getWorkflow();
            if (wfdef.getWorkflowCollection() == null) {
                throw new VWException("vw.api.VWFaultDefinitionNullWorkflowCollection", "The XPDL string cannot be created for this fault definition. The necessary reference to a containing workflow collection definition is null. \nEnsure that the workflow collection definition containing this fault definition is specified.");
            }
            theBuffer.append(indentB + "<BlockActivity ActivitySetId=\"Process" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(this.m_FaultMapName) + "\"/>\n");
        }
        theBuffer.append(indentA + "</WebServiceFaultCatch>\n");
    }

    public VWSession getSession() throws VWException {
        if (this.myInstruction != null && this.myInstruction.getStep() != null && this.myInstruction.getStep().getMap() != null && this.myInstruction.getStep().getMap().getWorkflow() != null) {
            return this.myInstruction.getStep().getMap().getWorkflow().getSession();
        }
        return null;
    }
}

